####################################################################
# R-code: Example 10.2; Table 10.1
# File: Example_10-2-Table2.r
# Coded by: Marcella Niglio
#
# Plug-in and Least Squares forecasts from SETARMA models
# Subroutines: prev.SETARMA.r (see file: LS-PI-forecast.r)
#              combina.r
#
# Reference:
# Niglio, M. (2007).
#   Multi-step forecasts from threshold ARMA models using asymmetric 
#   loss functions.
#   Statistical Methods & Applications, 16(3), 395-410.
#   DOI: 10.1007/s10260-007-0044-x.
####################################################################
########### EXAMPLE 10.2,  SETARMA(2;1,1,1,1) WITH intercept #######

var1 <- 1
var2 <- 1
h    <- 5
AR.first  <- c(0.6,0.6)
MA.first  <- c(-0.7,0)
AR.second <- c(-1,0.4)
MA.second <- c(0.5,0)
d   <- 1
v.s <- 0
rep <- 1000

lse      <- matrix(nrow=rep,ncol=h)
pie      <- matrix(nrow=rep,ncol=h)
lsmse    <- matrix(nrow=rep,ncol=5)
pimse    <- matrix(nrow=rep,ncol=5)
combmse  <- matrix(nrow=rep,ncol=5)

alsmse   <- matrix(nrow=rep,ncol=5)
apimse   <- matrix(nrow=rep,ncol=5)
acombmse <- matrix(nrow=rep,ncol=5)

ii <- 1
for (ii in 1:rep)
{
  dati    = rnorm(250)
  datiF   = rnorm(5)
  errori1 = rnorm(125,sd=1)
  errori2 = rnorm(125,sd=1)

  a     <- prev.SETARMA(dati,datiF,errori1,errori2,var1,var2,h,AR.first,MA.first,AR.second,MA.second,d,v.s)
  xx    <- a$MatricePrevisioni
  errls <- xx[3,1:5]
  errpi <- xx[7,1:5]

  lse[ii,] <- c(errls[[1]],errls[[2]],errls[[3]],errls[[4]],errls[[5]])
  pie[ii,] <- c(errpi[[1]],errpi[[2]],errpi[[3]],errpi[[4]],errpi[[5]])

  lsmse[ii,1] <- (errls[[1]]^2)
  lsmse[ii,2] <- (errls[[1]]^2+errls[[2]]^2)/2
  lsmse[ii,3] <- (errls[[1]]^2+errls[[2]]^2+errls[[3]]^2)/3
  lsmse[ii,4] <- (errls[[1]]^2+errls[[2]]^2+errls[[3]]^2+errls[[4]]^2)/4
  lsmse[ii,5] <- (errls[[1]]^2+errls[[2]]^2+errls[[3]]^2+errls[[4]]^2+errls[[5]]^2)/5
  
  pimse[ii,1] <- (errpi[[1]]^2)
  pimse[ii,2] <- (errpi[[1]]^2+errpi[[2]]^2)/2
  pimse[ii,3] <- (errpi[[1]]^2+errpi[[2]]^2+errpi[[3]]^2)/3
  pimse[ii,4] <- (errpi[[1]]^2+errpi[[2]]^2+errpi[[3]]^2+errpi[[4]]^2)/4
  pimse[ii,5] <- (errpi[[1]]^2+errpi[[2]]^2+errpi[[3]]^2+errpi[[4]]^2+errpi[[5]]^2)/5

##  MAPEs
  alsmse[ii,1] <- abs(errls[[1]])
  alsmse[ii,2] <- (abs(errls[[1]])+abs(errls[[2]]))/2
  alsmse[ii,3] <- (abs(errls[[1]])+abs(errls[[2]])+abs(errls[[3]]))/3
  alsmse[ii,4] <- (abs(errls[[1]])+abs(errls[[2]])+abs(errls[[3]])+abs(errls[[4]]))/4
  alsmse[ii,5] <- (abs(errls[[1]])+abs(errls[[2]])+abs(errls[[3]])+abs(errls[[4]])+abs(errls[[5]]))/5
  
  apimse[ii,1] <- abs(errpi[[1]])
  apimse[ii,2] <- (abs(errpi[[1]])+abs(errpi[[2]]))/2
  apimse[ii,3] <- (abs(errpi[[1]])+abs(errpi[[2]])+abs(errpi[[3]]))/3
  apimse[ii,4] <- (abs(errpi[[1]])+abs(errpi[[2]])+abs(errpi[[3]])+abs(errpi[[4]]))/4
  apimse[ii,5] <- (abs(errpi[[1]])+abs(errpi[[2]])+abs(errpi[[3]])+abs(errpi[[4]])+abs(errpi[[5]]) )/5
  
  aa   <- combina(a,h,d,v.s) 
  comb <- aa$erroriComb
  
  combmse[ii,1] <- (comb[1]^2)
  combmse[ii,2] <- (comb[1]^2+comb[2]^2)/2
  combmse[ii,3] <- (comb[1]^2+comb[2]^2+comb[3]^2)/3
  combmse[ii,4] <- (comb[1]^2+comb[2]^2+comb[3]^2+comb[4]^2)/4
  combmse[ii,5] <- (comb[1]^2+comb[2]^2+comb[3]^2+comb[4]^2+comb[5]^2)/5
  
  acombmse[ii,1] <- (abs(comb[1]) )
  acombmse[ii,2] <- (abs(comb[1])+abs(comb[2]))/2
  acombmse[ii,3] <- (abs(comb[1])+abs(comb[2])+abs(comb[3]))/3
  acombmse[ii,4] <- (abs(comb[1])+abs(comb[2])+abs(comb[3])+abs(comb[4]))/4
  acombmse[ii,5] <- (abs(comb[1])+abs(comb[2])+abs(comb[3])+abs(comb[4])+abs(comb[5]))/5
}

#############  EXAMPLE 10.2, SETARMA(2;1,1,1,1) NO (n) intercept ##############

var1      <- 1
var2      <- 1
h         <- 5
AR.first  <- c(0,0.6)
MA.first  <- c(-0.7,0)
AR.second <- c(-0,0.4)
MA.second <- c(0.5,0)
d         <- 1
v.s       <- 0
rep       <- 1000

lse       <- matrix(nrow=rep,ncol=h)
pie       <- matrix(nrow=rep,ncol=h)
nlsmse    <- matrix(nrow=rep,ncol=5)
npimse    <- matrix(nrow=rep,ncol=5)
ncombmse  <- matrix(nrow=rep,ncol=5)

nalsmse   <- matrix(nrow=rep,ncol=5)
napimse   <- matrix(nrow=rep,ncol=5)
nacombmse <- matrix(nrow=rep,ncol=5)

ii <- 1
for (ii in 1:rep)
{
  dati    = rnorm(250)
  datiF   = rnorm(5)
  errori1 = rnorm(125,sd=1)
  errori2 = rnorm(125,sd=1)

  a     <- prev.SETARMA(dati,datiF,errori1,errori2,var1,var2,h,AR.first,MA.first,AR.second,MA.second,d,v.s)
  xx    <- a$MatricePrevisioni
  errls <- xx[3,1:5]
  errpi <- xx[7,1:5]

  lse[ii,] <- c(errls[[1]],errls[[2]],errls[[3]],errls[[4]],errls[[5]])
  pie[ii,] <- c(errpi[[1]],errpi[[2]],errpi[[3]],errpi[[4]],errpi[[5]])

## MSPEs
  nlsmse[ii,1] <- (errls[[1]]^2)
  nlsmse[ii,2] <- (errls[[1]]^2+errls[[2]]^2)/2
  nlsmse[ii,3] <- (errls[[1]]^2+errls[[2]]^2+errls[[3]]^2)/3
  nlsmse[ii,4] <- (errls[[1]]^2+errls[[2]]^2+errls[[3]]^2+errls[[4]]^2)/4
  nlsmse[ii,5] <- (errls[[1]]^2+errls[[2]]^2+errls[[3]]^2+errls[[4]]^2+errls[[5]]^2)/5
  
  npimse[ii,1] <- (errpi[[1]]^2)
  npimse[ii,2] <- (errpi[[1]]^2+errpi[[2]]^2)/2
  npimse[ii,3] <- (errpi[[1]]^2+errpi[[2]]^2+errpi[[3]]^2)/3
  npimse[ii,4] <- (errpi[[1]]^2+errpi[[2]]^2+errpi[[3]]^2+errpi[[4]]^2)/4
  npimse[ii,5] <- (errpi[[1]]^2+errpi[[2]]^2+errpi[[3]]^2+errpi[[4]]^2+errpi[[5]]^2)/5

##  MAPEs
  nalsmse[ii,1] <- abs(errls[[1]])
  nalsmse[ii,2] <- (abs(errls[[1]])+abs(errls[[2]]))/2
  nalsmse[ii,3] <- (abs(errls[[1]])+abs(errls[[2]])+abs(errls[[3]]))/3
  nalsmse[ii,4] <- (abs(errls[[1]])+abs(errls[[2]])+abs(errls[[3]])+abs(errls[[4]]))/4
  nalsmse[ii,5] <- (abs(errls[[1]])+abs(errls[[2]])+abs(errls[[3]])+abs(errls[[4]])+abs(errls[[5]]))/5
  
  napimse[ii,1] <- abs(errpi[[1]])
  napimse[ii,2] <- (abs(errpi[[1]])+abs(errpi[[2]]))/2
  napimse[ii,3] <- (abs(errpi[[1]])+abs(errpi[[2]])+abs(errpi[[3]]) )/3
  napimse[ii,4] <- (abs(errpi[[1]])+abs(errpi[[2]])+abs(errpi[[3]])+abs(errpi[[4]]))/4
  napimse[ii,5] <- (abs(errpi[[1]])+abs(errpi[[2]])+abs(errpi[[3]])+abs(errpi[[4]])+abs(errpi[[5]]) )/5
    
## Combination     
  aa   <- combina(a,h,d,v.s) 
  comb <- aa$erroriComb
  
  ncombmse[ii,1] <- (comb[1]^2)
  ncombmse[ii,2] <- (comb[1]^2+comb[2]^2)/2
  ncombmse[ii,3] <- (comb[1]^2+comb[2]^2+comb[3]^2)/3
  ncombmse[ii,4] <- (comb[1]^2+comb[2]^2+comb[3]^2+comb[4]^2)/4
  ncombmse[ii,5] <- (comb[1]^2+comb[2]^2+comb[3]^2+comb[4]^2+comb[5]^2)/5
  
  nacombmse[ii,1] <- (abs(comb[1]) )
  nacombmse[ii,2] <- (abs(comb[1])+abs(comb[2]))/2
  nacombmse[ii,3] <- (abs(comb[1])+abs(comb[2])+abs(comb[3]))/3
  nacombmse[ii,4] <- (abs(comb[1])+abs(comb[2])+abs(comb[3])+abs(comb[4]))/4
  nacombmse[ii,5] <- (abs(comb[1])+abs(comb[2])+abs(comb[3])+abs(comb[4])+abs(comb[5]) )/5

}